
* File calcspec1.inc

* V1.0 - Base case
* V1.1 - Define FW and FWS for sets I and K rather than for each component
* V1.2 - Fold FWS into FW
* V1.3 - add (conditional) printing of recycle results - MH, 3/4/93


$ONTEXT
This calc file forms a blend of the specified subset of wastes (specified in w\
astcomp.prn) and performs a single optimization with the blended waste.
Each waste to be blended is a column in the table (matrix) WasteComps).
$OFFTEXT

Massoxide(Blends) = SUM(Waste, y.l(Blends, Waste) * WasteComps('OxideMass', Waste));
 
SOLVE WASTEOPTIM MINIMIZING Totalfrit USING MINLP;
*SOLVE WASTEOPTIM MINIMIZING terr USING miNLP;

Viscosity(Blends) = EXP(SUM(I,AV(I)*FG.L(Blends,I)) + SUM((I,J),BV(I,J)*FG.L(Blends,I)*FG.L(Blends,J)));
ElectCond(Blends) = EXP(SUM(I,AE(I)*FG.L(Blends,I)) + SUM((I,J),BE(I,J)*FG.L(Blends,I)*FG.L(Blends,J)));
BorDissPCT(Blends)= EXP(SUM(I,ADPB(I)*FG.L(Blends,I)) + SUM((I,J),BDPB(I,J)*FG.L(Blends,I)*FG.L(Blends,J)));
BorDissMCC(Blends)= EXP(SUM(I,ADMB(I)*FG.L(Blends,I)) + SUM((I,J),BDMB(I,J)*FG.L(Blends,I)*FG.L(Blends,J)));


  Display Totalfrit.L;
  Display z.l;
  Display Glass.L;
  Display Frit.L;
  Display WasteFrac.L;
  Display MassOxide, NumCans.L;
  Display TMWG.L, TMFG.L;
  Display Viscosity, ElectCond, BorDissPCT, BorDissMCC;
  Display FW.L, FF.L, FG.L;

